/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.api.event.AdvancementMovedEvent;
import betteradvancements.gui.BetterAdvancementEntryGui;
import betteradvancements.gui.BetterAdvancementTabGui;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementsScreen
extends Screen
implements ClientAdvancementManager.IListener {
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final ClientAdvancementManager clientAdvancementManager;
    private final Map<Advancement, BetterAdvancementTabGui> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTabGui selectedTab;
    private float zoom = 1.0f;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    private BetterAdvancementEntryGui advConnectedToMouse = null;

    public BetterAdvancementsScreen(ClientAdvancementManager clientAdvancementManager) {
        super(NarratorChatListener.field_216868_a);
        this.clientAdvancementManager = clientAdvancementManager;
    }

    protected void func_231160_c_() {
        this.internalHeight = this.field_230709_l_ * uiScaling / 100;
        this.internalWidth = this.field_230708_k_ * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancementManager.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancementManager.func_194230_a(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancementManager.func_194230_a(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
    }

    public void func_231164_f_() {
        this.clientAdvancementManager.func_192798_a(null);
        ClientPlayNetHandler clientPlayNetHandler = this.field_230706_i_.func_147114_u();
        if (clientPlayNetHandler != null) {
            clientPlayNetHandler.func_147297_a((IPacket)CSeenAdvancementsPacket.func_194164_a());
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int modifiers) {
        if (modifiers == 0) {
            int left = 30 + (this.field_230708_k_ - this.internalWidth) / 2;
            int top = 40 + (this.field_230709_l_ - this.internalHeight) / 2;
            for (BetterAdvancementTabGui betterAdvancementTabGui : this.tabs.values()) {
                if (!betterAdvancementTabGui.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, mouseX, mouseY)) continue;
                this.clientAdvancementManager.func_194230_a(betterAdvancementTabGui.getAdvancement(), true);
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, modifiers);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        int wheel = (int)scroll;
        if (wheel < 0 && this.zoom > 1.0f) {
            this.zoom -= 0.2f;
        } else if (wheel > 0 && this.zoom < 2.0f) {
            this.zoom += 0.2f;
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.field_230706_i_.field_71474_y.field_194146_ao.getKey().func_197937_c()) {
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.field_230708_k_ - this.internalWidth) / 2;
        int top = 40 + (this.field_230709_l_ - this.internalHeight) / 2;
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = mouseX < (double)(left + this.internalWidth - 60 - 9) && mouseX > (double)(left + 9) && mouseY < (double)(top + this.internalHeight - 40 + 1) && mouseY > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementEntryGui betterAdvancementEntryGui : this.selectedTab.guis.values()) {
                        if (!betterAdvancementEntryGui.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, mouseX - (double)left - 9.0, mouseY - (double)top - 18.0) || !betterAdvancementEntryGui.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryGui;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                AdvancementMovedEvent event = new AdvancementMovedEvent(this.advConnectedToMouse);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.field_230708_k_ - this.internalWidth) / 2;
        int top = 40 + (this.field_230709_l_ - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.field_230708_k_ - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.field_230709_l_ - this.internalHeight) / 2;
        this.func_230446_a_(matrixStack);
        this.renderInside(matrixStack, mouseX, mouseY, left, top, right, bottom);
        this.renderWindow(matrixStack, left, top, right, bottom);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(matrixStack, mouseX, mouseY, left, top, right, bottom);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementEntryGui betterAdvancementEntryGui : this.selectedTab.guis.values()) {
                if (betterAdvancementEntryGui == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryGui.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryGui.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryGui.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryGui.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryGui.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x1, y2 + 26 - 1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0, 65280);
                    }
                }
                if (betterAdvancementEntryGui.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(x2, y1, x1 + 26 - 1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x1 + 26 - 1, y1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1, x1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2 + 26 - 1, y2, 1.0, 65280);
                RenderUtil.drawRect(x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                    RenderUtil.drawRect(x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x2, y2, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                this.field_230712_o_.getClass();
                int currentY = n - 9 + 1;
                this.field_230712_o_.func_238421_b_(matrixStack, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, (float)currentX, (float)currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                float f = mouseX;
                this.field_230712_o_.getClass();
                this.field_230712_o_.func_238421_b_(matrixStack, string, f, (float)(mouseY - 9), 0);
            }
        }
    }

    private void renderInside(MatrixStack matrixStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        BetterAdvancementTabGui betterAdvancementTabGui = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTabGui == null) {
            BetterAdvancementsScreen.func_238467_a_((MatrixStack)matrixStack, (int)boxLeft, (int)boxTop, (int)boxRight, (int)boxBottom, (int)-16777216);
            String s = I18n.func_135052_a((String)"advancements.empty", (Object[])new Object[0]);
            int i = this.field_230712_o_.func_78256_a(s);
            float f = boxLeft + (width - i) / 2;
            int n = boxTop + height / 2;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, s, f, (float)(n - 9), -1);
            float f2 = boxLeft + (width - this.field_230712_o_.func_78256_a(":(")) / 2;
            int n2 = boxTop + height / 2;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, ":(", f2, (float)(n2 + 9), -1);
        } else {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)boxLeft, (double)boxTop, 0.0);
            RenderSystem.enableDepthTest();
            betterAdvancementTabGui.drawContents(matrixStack, width, height);
            matrixStack.func_227865_b_();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    public void renderWindow(MatrixStack matrixStack, int left, int top, int right, int bottom) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderHelper.func_74518_a();
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.Gui.WINDOW);
        this.func_238474_b_(matrixStack, left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating((AbstractGui)this, matrixStack, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        this.func_238474_b_(matrixStack, right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating((AbstractGui)this, matrixStack, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating((AbstractGui)this, matrixStack, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        this.func_238474_b_(matrixStack, left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating((AbstractGui)this, matrixStack, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        this.func_238474_b_(matrixStack, right - 30, bottom - 30, 222, 110, 30, 30);
        if (this.tabs.size() > 1) {
            this.field_230706_i_.func_110434_K().func_110577_a(Resources.Gui.TABS);
            int width = right - left;
            int height = bottom - top;
            for (BetterAdvancementTabGui tab : this.tabs.values()) {
                tab.drawTab(matrixStack, left, top, width, height, tab == this.selectedTab);
            }
            RenderSystem.enableRescaleNormal();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_227780_a_();
            for (BetterAdvancementTabGui tab : this.tabs.values()) {
                tab.drawIcon(matrixStack, left, top, width, height, this.field_230707_j_);
            }
            RenderSystem.disableBlend();
        }
        String windowTitle = I18n.func_135052_a((String)"gui.advancements", (Object[])new Object[0]);
        if (this.selectedTab != null) {
            windowTitle = windowTitle + " - " + this.selectedTab.getTitle().getString();
        }
        this.field_230712_o_.func_238421_b_(matrixStack, windowTitle, (float)(left + 8), (float)(top + 6), 0x404040);
    }

    private void renderToolTips(MatrixStack matrixStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            matrixStack.func_227860_a_();
            RenderSystem.enableDepthTest();
            matrixStack.func_227861_a_((double)(left + 9), (double)(top + 18), 400.0);
            this.selectedTab.drawToolTips(matrixStack, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            RenderSystem.disableDepthTest();
            matrixStack.func_227865_b_();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTabGui tab : this.tabs.values()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                this.func_238652_a_(matrixStack, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void func_191931_a(@Nonnull Advancement advancement) {
        BetterAdvancementTabGui betterAdvancementTabGui = BetterAdvancementTabGui.create(this.field_230706_i_, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement, betterAdvancementTabGui);
        }
    }

    public void func_191928_b(@Nonnull Advancement advancementIn) {
    }

    public void func_191932_c(@Nonnull Advancement advancementIn) {
        BetterAdvancementTabGui betterAdvancementTabGui = this.getTab(advancementIn);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancementIn);
        }
    }

    public void func_191929_d(@Nonnull Advancement advancementIn) {
    }

    public void func_191933_a(@Nonnull Advancement advancement, @Nonnull AdvancementProgress advancementProgress) {
        BetterAdvancementEntryGui betterAdvancementEntryGui = this.getAdvancementGui(advancement);
        if (betterAdvancementEntryGui != null) {
            betterAdvancementEntryGui.getAdvancementProgress(advancementProgress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancement) {
        this.selectedTab = this.tabs.get(advancement);
    }

    public void func_191930_a() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public BetterAdvancementEntryGui getAdvancementGui(Advancement advancement) {
        BetterAdvancementTabGui betterAdvancementTabGui = this.getTab(advancement);
        return betterAdvancementTabGui == null ? null : betterAdvancementTabGui.getAdvancementGui(advancement);
    }

    @Nullable
    private BetterAdvancementTabGui getTab(@Nonnull Advancement advancement) {
        while (advancement.func_192070_b() != null) {
            advancement = advancement.func_192070_b();
        }
        return this.tabs.get(advancement);
    }

    static {
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
    }
}

